/*
Copyright 2008-2009 Elöd Egyed-Zsigmond, Cyril Laitang
Copyright 2009-2011 Samuel Gesche

This file is part of IPRI News Analyzer.

IPRI News Analyzer is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

IPRI News Analyzer is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with IPRI News Analyzer.  If not, see <http://www.gnu.org/licenses/>.
*/

package data.base.connectors;

import data.base.Database;
import data.base.NoBaseException;

import proc.text.Codecs;

import java.sql.ResultSet;
import java.sql.SQLException;

import java.util.ArrayList;

public class OntologieDatabase {
    private Database myDB;
    public OntologieDatabase(Database db){
        myDB = db;
    }
    public int insertRessource(String ressource, String nom) throws NoBaseException {
        String query = String.format("INSERT INTO ipri_ontologie(ressource, nom, ressourceId)  VALUES('%s', '%s', "+2+")",
                Codecs.escapeHTML(ressource),
                Codecs.escapeHTML(nom));
        return myDB.executeInsertOrUpdate(query);
    }
    public int createRelationships(int concept2, String ressource) throws NoBaseException {
        int concept1 = getConceptID(ressource);
        if(concept1 != 0){
            String query = String.format("INSERT INTO ipri_relation(ConceptID1, RelationType, ConceptID2, idSemantic_ressources)  " +
                    "VALUES("+concept1+", 'hierarchie', "+concept2+", 2)");

            return myDB.executeInsertOrUpdate(query);
        }
        return 0;

    }
    private int getConceptID(String ressource) throws NoBaseException {
        String query = String.format("SELECT id FROM ipri_ontologie WHERE ressource = '%s'",
                Codecs.escapeHTML(ressource));
        int id = 0;
        ResultSet rs = myDB.executeSelection(query);
        try {
            while (rs.next()) {
                id = rs.getInt("id");
            }
        } catch (SQLException e) {
            System.out.println("error on get idRSSitem last key " + e.toString());
        }
        return id;
    }
    public ArrayList getLowerNodes() throws NoBaseException {
        ArrayList lowerChilds = new ArrayList();
        String query = String.format("SELECT DISTINCT conceptID2 FROM ipri_relation WHERE idSemantic_ressources =2" +
                " AND conceptID2 NOT IN (" +
                " SELECT conceptID1 FROM ipri_relation WHERE idSemantic_ressources =2)"
                );
        ResultSet rs = myDB.executeSelection(query);
        try {
            while (rs.next()) {
                lowerChilds.add(rs.getInt("conceptID2"));
            }
        } catch (SQLException e) {
            System.out.println("error on get idRSSitem last key " + e.toString());
        }
        return lowerChilds;
    }

    public ArrayList getHigherNodes() throws NoBaseException {
        ArrayList lowerChilds = new ArrayList();
        String query = String.format("SELECT DISTINCT conceptID1 FROM ipri_relation WHERE idSemantic_ressources =2" +
                " AND conceptID2 NOT IN (" +
                " SELECT conceptID1 FROM ipri_relation WHERE idSemantic_ressources =2)"
                );
        ResultSet rs = myDB.executeSelection(query);
        try {
            while (rs.next()) {
                lowerChilds.add(rs.getInt("conceptID1"));
            }
        } catch (SQLException e) {
            System.out.println("error on get idRSSitem last key " + e.toString());
        }
        return lowerChilds;
    }

    public String getRessource(int id) throws NoBaseException {
        String result = new String();
        String query = String.format("SELECT ressource FROM ipri_ontologie WHERE id ="+id+"");
        ResultSet rs = myDB.executeSelection(query);
        try {
            while (rs.next()) {
                result = rs.getString("ressource");
            }
        } catch (SQLException e) {
            System.out.println("error on get id last key " + e.toString());
        }
        return result;
    }
}
